% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal_oversampling.R
\name{bal_oversampling}
\alias{bal_oversampling}
\title{Oversampling}
\usage{
bal_oversampling(attribute)
}
\arguments{
\item{attribute}{The class attribute to target balancing using oversampling.}
}
\value{
A \code{bal_oversampling} object.
}
\description{
Oversampling balances the class distribution of a dataset by increasing the representation of the minority class in the dataset.
It wraps the smotefamily library.
}
\examples{
data(iris)
mod_iris <- iris[c(1:50,51:71,101:111),]

bal <- bal_oversampling('Species')
bal <- daltoolbox::fit(bal, mod_iris)
adjust_iris <- daltoolbox::transform(bal, mod_iris)
table(adjust_iris$Species)
}
