% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.dea.R
\name{summary.dea}
\alias{summary.dea}
\title{Summary conventional DEA models.}
\usage{
\method{summary}{dea}(object, exportExcel = TRUE, filename = NULL, returnList = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{"dea"} obtained by a dea model function.}

\item{exportExcel}{Logical value. If TRUE (default) the results are also exported to an Excel file}

\item{filename}{Character string. Absolute filename (including path) of the exported Excel file. 
If NULL, then the name of the file will be "ResultsDEA"+timestamp.xlsx.}

\item{returnList}{Logical value. If TRUE then the results are given as a list of data frames. 
If FALSE (default) all the data frames are merged into a single data frame.}

\item{...}{Ignored. Used for compatibility issues.}
}
\value{
Depending on the model it returns a single data.frame containing: efficiencies, 
slacks, lambdas, targets, references or a list of data.frames with the cross-efficiencies computed 
with different methods (Arbitrary, Method II or Method III (see CITA)) or, in case the model is a
 malmquist index, a single data.frame with the coefficients for the different periods.
}
\description{
Summary of the results obtained by a conventiona DEA model.
}
\examples{
data("PFT1981") 
# Selecting DMUs in Program Follow Through (PFT)
PFT <- PFT1981[1:49, ] 
PFT <- read_data(PFT, 
                 inputs = 2:6, 
                 outputs = 7:9 )
eval_pft <- model_basic(PFT, 
                        orientation = "io", 
                        rts = "crs")
summary(eval_pft, exportExcel = FALSE)

}
\references{
Charnes, A.; Cooper, W.W.; Rhodes, E. (1981). "Evaluating Program and Managerial 
Efficiency: An Application of Data Envelopment Analysis to Program Follow Through", 
Management Science, 27(6), 668-697. 
\url{https://pubsonline.informs.org/doi/abs/10.1287/mnsc.27.6.668}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
