% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_addmin.R
\name{model_addmin}
\alias{model_addmin}
\title{Additive-min DEA model.}
\usage{
model_addmin(datadea,
               dmu_eval = NULL,
               dmu_ref = NULL,
               orientation = NULL,
               weight_slack_i = 1,
               weight_slack_o = 1,
               rts = c("crs", "vrs", "nirs", "ndrs"),
               method = c("mf", "milp"),
               extreff = NULL,
               M_d = NULL,
               M_lambda = 1e3,
               maxfr = NULL,
               tol = 1e-6,
               silent = TRUE,
               compute_target = TRUE,
               check_target = FALSE,
               returnlp = FALSE,
               ...)
}
\arguments{
\item{datadea}{A \code{deadata} object with \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{orientation}{This parameter is either \code{NULL} (default) or a string, equal to
"io" (input-oriented) or "oo" (output-oriented). It is used to modify the weight slacks. 
If input-oriented, \code{weight_slack_o} are taken 0.
If output-oriented, \code{weight_slack_i} are taken 0.}

\item{weight_slack_i}{A value, vector of length \code{m}, or matrix \code{m} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval})
with the weights of the input slacks. If 0, output-oriented.}

\item{weight_slack_o}{A value, vector of length \code{s}, or matrix \code{s} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval})
with the weights of the output slacks. If 0, input-oriented.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing) or "ndrs" (non-decreasing). Under non-increasing
or non-decreasing returns to scale, you may set \code{check_target = TRUE} because
methods are not reliable. Generalized returns to scale are not available.}

\item{method}{A string with the method: "mf" (default) for maximal friends, or "milp"
for the mixed integer linear program of Aparicio et al. (2007). MILP method is
faster but very problematic numerically.}

\item{extreff}{A vector with the extreme efficient DMUs for "milp" method, as it
is returned by function \code{extreme_efficient}.  If \code{NULL} (default)
this vector is computed internally.}

\item{M_d}{Numeric, a big positive quantity for "milp" method. It is an upper
bound for auxiliary variables named "d" in Aparicio (2007). If \code{NULL}
(default), it is estimated automatically. A very big value can produce catastrophic
cancellations. If the results are not correct or the solver hangs, try to change its value.}

\item{M_lambda}{Numeric, a big positive quantity for "milp" method. It is an upper
bound for lambda variables. A very big value can produce catastrophic cancellations.
If the results are not correct or the solver hangs, try to change its value (1e3 by default).}

\item{maxfr}{A list with the maximal friends sets for "mf" method, as it is returned by function
\code{maximal_friends}. If \code{NULL} (default) this list is computed internally.}

\item{tol}{Numeric, a tolerance margin for checking efficiency in \code{extreme_efficient}
or \code{maximal_friends} functions, and for checking targets.}

\item{silent}{Logical. If \code{FALSE}, it prints all the messages from
function \code{maximal_friends}.}

\item{compute_target}{Logical. If it is \code{TRUE} (default), it computes targets.
We note that we call "targets" to the "efficient projections"
in the strongly efficient frontier.}

\item{check_target}{Logical. If it is \code{TRUE}, it checks the efficiency of targets.
If a target is not efficient, the method has failed.}

\item{returnlp}{Logical. If it is \code{TRUE}, it returns the linear problems
(objective function and constraints).}

\item{...}{For compatibility issues.}
}
\value{
A list of class \code{dea} with the results for the evaluated DMUs (\code{DMU} component),
 along with any other necessary information to replicate the results, such as
 the name of the model and parameters \code{orientation}, \code{rts},
 \code{dmu_eval} and \code{dmu_ref}.
}
\description{
Solve the weighted version of the additive-min (mADD) model of
Aparicio et. al (2007) with different returns to scale. For non constant returns
to scale, a modification given by Zhu et al. (2018) is done.
}
\note{
In this model, the efficiency score is the sum of the slacks. Therefore,
a DMU is efficient when the objective value (\code{objval}) is zero.
}
\examples{
# Example 1.
data("Airlines")
datadea <- make_deadata(Airlines,
                        inputs = 4:7,
                        outputs = 2:3)
result <- model_addmin(datadea = datadea,
                       method = "milp")
targets(result)

\dontrun{
# Example 2. Directional model with Additive-min model in second stage 
data("Airlines")
datadea <- make_deadata(Airlines,
                        inputs = 4:7,
                        outputs = 2:3)
resdir <- model_basic(datadea = datadea,
                      orientation = "dir",
                      maxslack = FALSE)
proj_input <- targets(resdir)[[1]] + slacks(resdir)[[1]]
proj_output <- targets(resdir)[[2]] - slacks(resdir)[[2]]
nd <- ncol(datadea$dmunames) # Number of DMUs
maxfr <- maximal_friends(datadea = datadea)
for (i in 1:nd) {
  datadea2 <- datadea
  datadea2$input[, i] <- proj_input[i, ]
  datadea2$output[, i] <- proj_output[i, ]
  DMUaux <- model_addmin(datadea = datadea2,
                         method = "mf",
                         maxfr = maxfr,
                         dmu_eval = i)$DMU[[1]]
  resdir$DMU[[i]]$slack_input <- DMUaux$slack_input
  resdir$DMU[[i]]$slack_output <- DMUaux$slack_output
  resdir$DMU[[i]]$target_input <- DMUaux$target_input
  resdir$DMU[[i]]$target_output <- DMUaux$target_output
}
targets(resdir)
}

}
\references{
Aparicio, J.; Ruiz, J.L.; Sirvent, I. (2007) "Closest targets and minimum
distance to the Pareto-efficient frontier in DEA", Journal of Productivity
Analysis, 28, 209-218. \doi{10.1007/s11123-007-0039-5}

Zhu, Q.; Wu, J.; Ji, X.; Li, F. (2018) "A simple MILP to determine closest
targets in non-oriented DEA model satisfying strong monotonicity", Omega, 79,
1-8. \doi{10.1016/j.omega.2017.07.003}
}
\seealso{
\code{\link{model_additive}}, \code{\link{extreme_efficient}},
\code{\link{maximal_friends}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
