% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{M_step}
\alias{M_step}
\title{M-step in the EAM algorithm described in KMS19.}
\usage{
M_step(
  dir,
  evaluations,
  theta.hash,
  fit.krige,
  test.fun,
  c,
  par.space,
  hyperparams,
  verbose
)
}
\arguments{
\item{dir}{Direction to search in. \code{dir = 1} corresponds to finding the
upper bound of the confidence interval. \code{dir = -1} corresponds to
finding the lower bound.}

\item{evaluations}{Matrix containing each point that was already evaluated,
alongside the corresponding test statistic and critical value, as its rows.}

\item{theta.hash}{Tentative best value of theta. Obtained from the E-step.}

\item{fit.krige}{Kriging model obtained from the A-step.}

\item{test.fun}{The test function to be inverted in order to obtain the
identified set.}

\item{c}{Projection vector.}

\item{par.space}{Bounds of the parameter space.}

\item{hyperparams}{Parameters used in obtaining initial values
for the maximization algorithm. If \code{NULL}, default values are used.
Default is \code{hyperparams = NULL}.}

\item{verbose}{Verbosity parameter.}
}
\description{
This function performs the maximization step in the EAM
algorithm. More specifically, it maximizes the expected improvement.
ToDo: implement sample space contractions (see comment made in documentation
of \code{draw.sv.init}).
}
