% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{normalize.covariates}
\alias{normalize.covariates}
\title{Normalize the covariates of a data set to lie in the unit interval by
scaling based on the ranges of the covariates.}
\usage{
normalize.covariates(
  data = NULL,
  x = NULL,
  cov.ranges = NULL,
  idxs.c = "all",
  norm.cov.out = NULL,
  ...
)
}
\arguments{
\item{data}{(optional) Data set to be used to construct the normalizing
transformation. Default is \code{data = NULL}.}

\item{x}{(optional) Vector of covariates to be normalized alongside the data.
Default is \code{x = NULL}.}

\item{cov.ranges}{(optional) Matrix that specifies the range of each of the
covariates in the data set. Each column corresponds to a covariate. The first
row contains the lower bound, the second row contains the upper bound.
If not supplied, the data will be normalized based on the minimum and maximum
detected values. If supplied, the non data-dependent transformation function
listed in the appendix of Andrews, Shi 2013 will be used. Default is
\code{cov.ranges = NULL}.}

\item{idxs.c}{(optional) Vector of indices of covariates that are continuous.
Note that that indices are relative to the covariate vector, not the full
data set. Default value is \code{idxs.c = "all"}, which indicates that all
elements should be regarded as continuous. If \code{idxs.c = NULL}, all
elements are regarded as discrete.}

\item{norm.cov.out}{(optional) The output of a previous call to this function.
Can be used to speed up computation. If both \code{data} and
\code{norm.cov.out} are supplied to the function, this method will throw an
error. Default is \code{norm.cov.out = NULL}.}

\item{...}{Allows easier interchangeability between covariate normalization
functions. All arguments specified under \code{...} will be ignored.}
}
\description{
This function normalized the covariates in the data to lie in
the unit interval based on either the empirical or known ranges of the
covariates. It is useful to perform this step when defining the instrumental
functions later on. This function is used in \code{G.box.R}, \code{G.spline.R}
and by extension in \code{G.cd.R}.
}
\references{
Andrews, D.W.K. and Shi, X. (2013). Inference based on
confitional moment inequalities. Econometrica. 81(2):609-666.
}
