% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-hfilter.R
\name{plot,hfilter-method}
\alias{plot,hfilter-method}
\title{Plot Method for the Results of a Hamilton Filter}
\usage{
\S4method{plot}{hfilter}(x, which = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{"hfilter"}, as returned by the function 
\code{\link{hamilton_filter}}.}

\item{which}{either a string or a number can be entered to select a 
plot type from the function call; options are (1) a facet plot of the 
components, (2) the observed time series, (3) the observations together 
with the fitted values, and (4) the residuals; for \code{which = NULL}, 
the plot type can be selected interactively in the console.}

\item{...}{further arguments to pass to \code{\link[stats]{plot.ts}} or 
\code{\link[graphics]{matplot}} (depending on whether only one time series
or multiple time series are shown in the plot).}
}
\value{
This function returns \code{NULL}.
}
\description{
Visualize the results of an applied Hamilton filter.
}
\examples{
est <- hamilton_filter(log(EXPENDITURES))
plot(est, which = 3, col = c(1, 6))
plot(est, which = 4)

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
