% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_conversion.R
\name{read_ts}
\alias{read_ts}
\title{Read in a Dataset Directly as an Object of Class \code{"ts"} or \code{"mts"}}
\usage{
read_ts(
  file,
  time_column = 1,
  sep = ",",
  dec = ".",
  header = TRUE,
  time_format = NULL
)
}
\arguments{
\item{file}{a data file name given as a string (including the file ending);
the file should have at least two columns: one time column and at least one or 
multiple columns for time series observations; alternatively, a data frame 
can be passed to this argument.}

\item{time_column}{a number that indicates which column in the dataset is 
the variable with the time points; by default, the first column is assumed to 
contain the information on time points.}

\item{sep}{the separation symbol between the dataset columns.}

\item{dec}{the decimal symbol in the dataset.}

\item{header}{\code{TRUE} or \code{FALSE}; does the dataset have a row 
with headers at the beginning?}

\item{time_format}{with the default \code{NULL}, standard date formats will 
be tried to transform the time points column into a date object; if the 
formatting of the time column is unusual, the formatting can be specified 
here as a string.}
}
\value{
An object of class \code{"ts"} or \code{"mts"} is returned.
}
\description{
Allows the user to read in a data file directly as a \code{"ts"} or 
\code{"mts"} object, where a time point column in the data file is 
immediately used to set starting points and frequency of the time 
series automatically correctly. Works for equidistant observation time 
points, e.g. quarterly or monthly observations.
}
\details{
The data file is internally read into R as a \code{"zoo"} object and then 
transformed into a \code{"ts"} object using \code{\link{zoo_to_ts}}. This 
happens without the user noticing. The result is an immediate transformation 
of the input data into an object of class \code{"ts"} or \code{"mts"} for 
the user.
}
\examples{
\donttest{
### Create an example data file
a <- 1:12
b <- 21:32
tp <- seq(from = as.Date("2020-01-01"), to = as.Date("2020-12-01"), by = "month")
df <- data.frame(
 Time = tp,
 a = a,
 b = b
)

file <- paste0(tempdir(), "\\\\ExampleFile.csv")

write.table(df, file = file, quote = FALSE, sep = ",",
 row.names = FALSE, col.names = TRUE)
 
### Use the function to read in the data
xt <- read_ts(file)
xt
}

}
