% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nllik}
\alias{nllik}
\title{Calculate the predictive negative log-likelihood}
\usage{
nllik(object, x, y)
}
\arguments{
\item{object}{an instance of the \code{dgp} class and it should be produced by \code{\link[=dgp]{dgp()}} with \code{likelihood} not being \code{NULL};}

\item{x}{a matrix where each row is an input testing data point and each column is an input dimension.}

\item{y}{a matrix with only one column where each row is a scalar-valued testing output data point.}
}
\value{
An updated \code{object} is returned with an additional slot named \code{NLL} that contains two elements.
The first one, named \code{meanNLL}, is a scalar that gives the average negative predicted log-likelihood
across all testing data points. The second one, named \code{allNLL}, is a vector that gives the negative predicted
log-likelihood for each testing data point.
}
\description{
This function computes the predictive negative log-likelihood from a
DGP emulator with a likelihood layer.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
