% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/bootstrap.R
\docType{methods}
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap-method}
\alias{bootstrap,CA-method}
\alias{bootstrap,PCA-method}
\title{Partial Bootstrap Analysis}
\usage{
bootstrap(object, ...)

\S4method{bootstrap}{CA}(object, n = 30)

\S4method{bootstrap}{PCA}(object, n = 30)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
#'
Returns a \code{\linkS4class{BootstrapCA}} or a \code{\linkS4class{BootstrapPCA}} object.
}
\description{
Checks analysis with partial bootstrap resampling.
}
\examples{
## Bootstrap on CA
## Data from Lebart et al. 2006, p. 170-172
data("colours")

## Compute correspondence analysis
X <- ca(colours)

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

\dontrun{
## Get replicated coordinates
get_replications(Y, margin = 1)
get_replications(Y, margin = 2)
}

## Plot with ellipses
plot_rows(Y, colour = "group") +
  ggplot2::stat_ellipse()

## Plot with convex hulls
plot_columns(Y, colour = "group", fill = "group") +
  stat_hull(geom = "polygon", alpha = 0.5)

## Bootstrap on PCA
## Compute principal components analysis
data("iris")
X <- pca(iris)

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

## Plot with ellipses
plot_columns(Y, colour = "group") +
  ggplot2::stat_ellipse()
}
\references{
Greenacre, Michael J. \emph{Theory and Applications of Correspondence
Analysis}. London: Academic Press, 1984.

Lebart, L., Piron, M. and Morineau, A. \emph{Statistique exploratoire
multidimensionnelle: visualisation et inférence en fouille de données}.
Paris: Dunod, 2006.
}
\author{
N. Frerebeau
}
\concept{resampling methods}
