% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_eigenvalues}
\alias{plot_eigenvalues}
\alias{plot_variance}
\alias{plot_variance-method}
\alias{plot_variance,MultivariateAnalysis-method}
\title{Visualize Eigenvalues}
\usage{
plot_variance(object, ...)

\S4method{plot_variance}{MultivariateAnalysis}(
  object,
  variance = TRUE,
  cumulative = TRUE,
  fill = "grey30",
  border = "grey10",
  colour = "red"
)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{variance}{A \code{\link{logical}} scalar: should the percentages of variance be
plotted instead of the eigenvalues?}

\item{cumulative}{A \code{\link{logical}} scalar: should the cumulative percentages of
variance be plotted?}

\item{fill, border}{A \code{\link{character}} string specifying the bars infilling and
border colors.}

\item{colour}{A \code{\link{character}} string specifying the line color.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plot eigenvalues or variances histogram.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
Y <- pca(iris, scale = TRUE)

## Plot results
plot_individuals(Y, colour = "group", shape = "group", group = iris$Species) +
  khroma::scale_colour_highcontrast()

plot_individuals(Y, colour = "group", size = "cos2", group = iris$Sepal.Width) +
  khroma::scale_color_YlOrBr()

plot_individuals(Y, colour = "contribution", size = "contribution") +
  khroma::scale_color_iridescent(range = c(0.5, 1))

plot_variables(Y, colour = "contribution") +
  ggrepel::geom_label_repel() +
  khroma::scale_color_YlOrBr(range = c(0.5, 1))
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{envelopes}},
\code{\link{plot_contributions}()},
\code{\link{plot_coordinates}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
