% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_ExoticStatistics.R
\name{survival}
\alias{survival}
\title{Survival Function}
\usage{
survival(object, x1, log = FALSE)
}
\arguments{
\item{object}{Distribution.}

\item{x1}{Point to evaluate the survival function at.}

\item{log}{logical, if TRUE then the (natural) logarithm of the survival function is returned.}
}
\value{
Survival function as a numeric, natural logarithm returned if \code{log} is TRUE.
}
\description{
The survival function of a probability distribution is the probability of surviving
after a point x.
}
\details{
The survival function is defined by
\deqn{S_X(x) = P(X \ge x) = 1 - F_X(x) = \int_x^\infty f_X(x) dx}
where X is the distribution, \eqn{S_X} is the survival function, \eqn{F_X} is the cdf and \eqn{f_X} is the pdf.

Can only be used after decorating with \code{\link{ExoticStatistics}}.
}
\section{R6 Usage}{
 $survival(x1, log = FALSE)
}

\seealso{
\code{\link{ExoticStatistics}} and \code{\link{decorate}}
}
