% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixturiseVector.R
\name{mixturiseVector}
\alias{mixturiseVector}
\title{Create Mixture Distribution From Multiple Vectors}
\usage{
mixturiseVector(vecdists, weights = "uniform")
}
\arguments{
\item{vecdists}{\code{(list())}\cr
List of \link{VectorDistribution}s, should be of same length and with the non-`distlist'
constructor with the same distribution.}

\item{weights}{\code{(character(1)|numeric())}\cr
Weights passed to \link{MixtureDistribution}. Default uniform weighting.}
}
\description{
Given \code{m} vector distributions of length \code{N}, creates a single vector
distribution consisting of \code{n} mixture distributions mixing the \code{m} vectors.
}
\details{
Let \eqn{v1 = (D11, D12,...,D1N)} and \eqn{v2 = (D21, D22,...,D2N)} then the
\code{mixturiseVector} function creates the vector distribution \eqn{v3 = (D31, D32, ..., D3N)}
where \code{D3N = m(D1N, D2N, wN)} where \code{m} is a mixture distribution with weights \code{wN}.
}
\examples{
v1 <- VectorDistribution$new(distribution = "Binomial", params = data.frame(size = 1:2))
v2 <- VectorDistribution$new(distribution = "Binomial", params = data.frame(size = 3:4))
mv1 <- mixturiseVector(list(v1, v2))

# equivalently
mv2 <- VectorDistribution$new(list(
  MixtureDistribution$new(distribution = "Binomial", params = data.frame(size = c(1, 3))),
  MixtureDistribution$new(distribution = "Binomial", params = data.frame(size = c(2, 4)))
))

mv1$pdf(1:5)
mv2$pdf(1:5)

}
