% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summarize_genes}
\alias{summarize_genes}
\title{Summarize the differential connectivity of genes over all pathways.}
\usage{
summarize_genes(x, alpha_gene = NULL, monotonized = FALSE)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{alpha_gene}{Threshold for p-values of gene DC scores. Used to determine
the number of pathways that each gene is differentially connected in. If NULL,
defaults to 0.05 or the minimum possible threshold (based on the
number of permutatiosn that were run).}

\item{monotonized}{If TRUE, monotonized p-values are used.}
}
\value{
A tibble summarizing the differential connectivity of genes across
all pathways.
}
\description{
Summarize the differential connectivity of genes over all pathways.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
summarize_genes(results) # Summary of genes across all pathways.
summarize_genes(results[[1]]) # Summary of genes within the first pathway.
}
\seealso{
\code{\link{summarize_pathways}}, \code{\link{summarize_edges}}
}
