% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_age_equivalent.R
\name{get_age_equivalent}
\alias{get_age_equivalent}
\title{Get age equivalents of items that have a difficulty estimate}
\usage{
get_age_equivalent(
  items,
  pct = c(10, 50, 90),
  key = NULL,
  population = NULL,
  transform = NULL,
  itembank = dscore::builtin_itembank,
  xunit = c("decimal", "days", "months"),
  verbose = FALSE
)
}
\arguments{
\item{items}{A character vector containing names of items to be
included into the D-score calculation. Milestone scores are coded
numerically as \code{1} (pass) and \code{0} (fail). By default,
D-score calculation is done on all items found in the data
that have a difficulty parameter under the specified \code{key}.}

\item{pct}{Numeric vector with requested percentiles (0-100). The
default is \code{pct = c(10, 50, 90)}.}

\item{key}{String. They key identifies 1) the difficulty estimates
pertaining to a particular Rasch model, and 2) the prior mean and standard
deviation of the prior distribution for calculating the D-score.
The default key \code{NULL} sets \code{key = "gsed2406"}.
View \code{builtin_keys} for an overview of the available keys.}

\item{population}{String. The name of the reference population to calculate
DAZ.
Use \code{with(builtin_references, table(key, population))} to see which
built-in references are available for \code{key - population} combinations.
If not specified, the function set the default population as
\code{builtin_keys$base_population[key == builtin_keys$key]}.}

\item{transform}{Numeric vector, length 2, containing the intercept
and slope of the linear transform from the logit scale into the
the D-score scale. The default (\code{NULL}) searches \code{builtin_keys}
for intercept and slope values.}

\item{itembank}{A \code{data.frame} with at least three columns named
\code{key}, \code{item} and \code{tau}. By default, the function uses
\code{dscore::builtin_itembank}. If you specify your own \code{itembank},
then you should also provide the relevant \code{transform} and \code{qp} arguments.}

\item{xunit}{A string specifying the unit in which age is measured
(either \code{"decimal"}, \code{"days"} or \code{"months"}).
The default \code{"decimal"} corresponds to decimal age in years.}

\item{verbose}{Logical. Print settings.}
}
\value{
\code{data.frame} with four columns: \code{item}, \code{d} (D-score),
\code{pct} (percentile), and \code{a} (age-equivalent, in \code{xunit} units).
}
\description{
This function calculates the ages at which a certain percent
in the reference population passes the items.
}
\note{
The function internally defines a scale factor given the key.
}
\examples{
get_age_equivalent(c("gpagmc018", "gtogmd026", "ddicmm050"))
}
