% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cord_s3.R
\name{simulate.cord}
\alias{simulate.cord}
\title{Simulates new data from a given cord object}
\usage{
\method{simulate}{cord}(object, nsim = 1, seed = NULL, newdata = object$obj$data, ...)
}
\arguments{
\item{object}{is a cord object, e.g. from output of \code{cord}}

\item{nsim}{Number of simulations, defaults to 1. If nsim > 1, the simulated data will be
appended.}

\item{seed}{Random number seed, defaults to a random seed number.}

\item{newdata}{A data frame in which to look for X covariates with which to simulate.}

\item{...}{not used
Defaults to the X covariates in the fitted model.}
}
\description{
Simulates new data from a given cord object
}
\examples{
abund = spider$abund
X = data.frame(spider$x)

spider_mod_ssdm = stackedsdm(abund,~1, data = X, ncores=2)
spid_lv_ssdm = cord(spider_mod_ssdm)
simulate(spid_lv_ssdm, nsim=2)

\donttest{
# using mvabund
library(mvabund) #for manyglm
abund=mvabund(abund)
spider_mod = manyglm(abund~1)
spid_lv = cord(spider_mod)
simulate(spid_lv)

spider_mod_X = manyglm(abund ~ soil.dry + bare.sand, data=X)
spid_lv_X = cord(spider_mod_X)
Xnew = X[1:10,]
simulate(spid_lv_X, newdata = Xnew)
simulate(spid_lv_X, nsim=2, newdata = Xnew)

spider_mod_X_ssdm = stackedsdm(abund, formula_X = ~. -bare.sand, data = X, ncores=2)
spid_lv_X_ssdm = cord(spider_mod_X_ssdm)
simulate(spid_lv_X_ssdm, newdata = Xnew)
}
}
