% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{predict.em}
\alias{predict.em}
\title{Predict the fitted finite mixture models}
\usage{
\method{predict}{em}(object, prob = c("prior", "posterior"), ...)
}
\arguments{
\item{object}{Output from \code{em}, representing a fitted model using EM algorithm.}

\item{prob}{the probabilities used to compute the fitted value. It can be either
prior probability (`prior`) or posterior probability (`posterior`). 
The default value is `prior`.}

\item{...}{other arguments.}
}
\value{
An object of class `predict.em` is a list containing at least the following components:
   \code{components} a list of fitted values by components with each element 
   a matrix/vector of fitted values. 
   \code{mean} a matrix of predicted values computed by weighted sum of fitted values by components.
   The weights used in the computation can be either prior probabilities or posterior probabilities
   depending on the parameter `prob`.
   \code{prob} the value used in the parameter `prob`.
}
\description{
Predict the fitted finite mixture models
}
