% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embergerQ.R
\name{embergerQ}
\alias{embergerQ}
\title{Emberger's pluviometric quotient}
\usage{
embergerQ(P, M, m)
}
\arguments{
\item{P}{rasterLayer, mean annual precipitation}

\item{M}{rasterLayer, mean max temperature of the warmest month}

\item{m}{rasterLayer, mean min temperature of the coldest month}
}
\value{
rasterLayer in mm / degrees C
}
\description{
Calculate Emberger's pluviometric quotient.
}
\details{
\code{Q = 2000 P / [(M + m + 546.4) * (M - m)]}
}
\examples{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

embergerQ(env[['bio_12']], env[['bio_5']], env[['bio_6']])
}
\author{
Pascal Title
}
\references{
Daget, P. (1977) Le bioclimat méditerranéen: analyse des formes climatiques 
par le système d’Emberger. \emph{Vegetatio}, \strong{34}, 87–103.
}

