% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanism.R
\name{export_mechanism}
\alias{export_mechanism}
\title{Export mechanisms}
\usage{
export_mechanism(
  mechanism,
  sc = NULL,
  file_name = NULL,
  file_type = "png",
  title = NULL,
  ...
)
}
\arguments{
\item{mechanism}{An object of class \code{epicmodel_mechanism}.}

\item{sc}{A single integer value (can be specified as numeric, e.g., 2 instead of 2L). If provided, a graph is only exported for the specified
sufficient cause, e.g., for SC2 if sc = 2. If sc = NULL (default), graphs for all sufficient causes are exported.}

\item{file_name}{The name of the exported file (including it's extension).}

\item{file_type}{The type of file to be exported. Options for graph files
are: \code{png}, \code{pdf}, \code{svg}, and \code{ps}.}

\item{title}{An optional title for the output graph.}

\item{...}{
  Arguments passed on to \code{\link[DiagrammeR:export_graph]{DiagrammeR::export_graph}}
  \describe{
    \item{\code{width}}{Output width in pixels or \code{NULL} for default. Only useful for
export to image file formats \code{png}, \code{pdf}, \code{svg}, and \code{ps}.}
    \item{\code{height}}{Output height in pixels or \code{NULL} for default. Only useful for
export to image file formats \code{png}, \code{pdf}, \code{svg}, and \code{ps}.}
  }}
}
\value{
Saves the mechanisms as PNG, PDF, SVG, or PostScript.
}
\description{
Exports one or all sufficient cause mechanisms as PNG, PDF, SVG, or PostScript using \code{DiagrammeR::export_graph()}.
}
\examples{
# Derive mechanisms
mech <- mechanism(scc_rain)

# Export mechanism plot of sufficient cause (sc) 1
if(interactive()){
tmp <- tempfile(fileext = ".png")
export_mechanism(mech, sc = 1, file_name = tmp, title = "Sufficient Cause 1")
unlink(tmp) # delete saved file
}
}
\seealso{
\itemize{
\item \code{\link[DiagrammeR:export_graph]{DiagrammeR::export_graph()}}
\item \code{\link[=mechanism]{mechanism()}} for information on sufficient cause mechanisms
}
}
