% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d3l.R
\name{eq5d3l}
\alias{eq5d3l}
\title{Calculate EQ-5D-3L index scores}
\usage{
eq5d3l(scores, type = "TTO", country = "UK", digits = 3)
}
\arguments{
\item{scores}{numeric with names MO, SC, UA, PD and AD representing
Mobility, Self-care, Usual activities, Pain/discomfort and Anxiety/depression.}

\item{type}{3L values set type. Either TTO or VAS.}

\item{country}{value set country.}

\item{digits}{number of decimal places to return.}
}
\value{
calculated utility index score.
}
\description{
Calculate indices for EQ-5D-3L value sets. Available value sets can be viewed
  using the function \code{valuesets}.
}
\examples{
eq5d3l(scores=c(MO=1,SC=2,UA=3,PD=1,AD=3), type="VAS", country="UK")
eq5d3l(scores=c(MO=3,SC=2,UA=3,PD=2,AD=3), type="TTO", country="Germany")

}
