% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED.boundary}
\alias{AED.boundary}
\title{Calculate the critical value used at the final analysis in APE}
\usage{
AED.boundary(rho, alpha, Info, epsilon)
}
\arguments{
\item{rho}{The proportion of subgroup 1}

\item{alpha}{The overall type I error rate}

\item{Info}{The infromation fraction}

\item{epsilon}{The threshold of difference between the subgroup-specific test
statistics}
}
\value{
The critical value used at the final analysis
}
\description{
\code{AED.boundary()} is used to calculate the critical value
    used at the final analysis in APE design, meanwhile preserving the overall
    type I error rate at \eqn{\alpha} level
}
\examples{
AED.boundary(rho = 0.5, alpha = 0.05, Info = 0.5, epsilon = 0.5)
}
\references{
\itemize{
  \item Zhao Yang, Ruitao Lin, Guosheng Yin and Ying Yuan. (2018) Sample Size
    Re-estimation in Adaptive Enrichment Trials. (Under Preparation)
}
}
