% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{goftest.hill.adapt}
\alias{goftest.hill.adapt}
\title{Goodness of fit test statistics}
\usage{
\method{goftest}{hill.adapt}(object, plot = FALSE, ...)
}
\arguments{
\item{object}{output of the function hill.adapt.}

\item{plot}{If \code{TRUE}, the test statistics are plotted.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{TS.window}{the test statistic inside the window. (pages 447 and 448 of Durrieu et al.(2015))}
\item{TS}{the test statistic.}
\item{CritVal}{the critical value of the test.}
}
\description{
Give the results of the goodness of fit tests for testing the null hypothesis that the tail is fitted by a Pareto distribution, starting from the adaptive threshold, against the Pareto change point distribution for all possible change points (for more details see pages 447 and 448 of Durrieu et al. (2015)).
}
\examples{
x <- abs(rcauchy(100))
HH <- hill.adapt(x, weights=rep(1, length(x)), initprop = 0.1,
               gridlen = 100 , r1 = 0.25, r2 = 0.05, CritVal=10)

#the critical value 10 is assiociated to the rectangular kernel.

goftest(HH, plot = TRUE)

# we observe that for this data, the null hypothesis that the tail
# is fitted by a Pareto distribution is not rejected as the maximal
# value in the graph does not exceed the critical value.


}
\references{
Grama, I. and Spokoiny, V. (2008). Statistics of extremes by oracle estimation. Ann. of Statist., 36, 1619-1648.

Durrieu, G. and Grama, I. and Pham, Q. and Tricot, J.- M (2015). Nonparametric adaptive estimator of extreme conditional tail probabilities quantiles. Extremes, 18, 437-478.
}
\seealso{
\code{\link{hill.adapt}}, \code{\link{goftest}}
}
