% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fairness.R
\name{eval_treatment_equality}
\alias{eval_treatment_equality}
\title{Examine Treatment Equality of a Model}
\usage{
eval_treatment_equality(
  data,
  outcome,
  group,
  probs,
  cutoff = 0.5,
  confint = TRUE,
  alpha = 0.05,
  bootstraps = 2500,
  digits = 2,
  message = TRUE
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{Name of the outcome variable}

\item{group}{Name of the sensitive attribute}

\item{probs}{Predicted probabilities}

\item{cutoff}{Cutoff value for the predicted probabilities}

\item{confint}{Logical indicating whether to calculate confidence intervals}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{bootstraps}{Number of bootstraps to use for confidence intervals}

\item{digits}{Number of digits to round the results to, default is 2}

\item{message}{Whether to print the results, default is TRUE}
}
\value{
A list containing the following elements:
\itemize{
\item False Negative / False Positive ratio for Group 1
\item False Negative / False Positive ratio for Group 2
\item Difference in False Negative / False Positive ratio
\item Ratio in False Negative / False Positive ratio
If confidence intervals are computed (\code{confint = TRUE}):
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the difference in False Negative / False Positive ratio
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the ratio in False Negative / False Positive ratio
}
}
\description{
This function evaluates \emph{Treatment Equality}, a fairness criterion that assesses whether the
ratio of false negatives to false positives is similar across groups (e.g., based on gender or race).
Treatment Equality ensures that the model does not disproportionately favor or disadvantage any group
in terms of the relative frequency of missed detections (false negatives) versus false alarms (false positives).
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
# Data for tests
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.

# Evaluate Treatment Equality
eval_treatment_equality(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred",
  cutoff = 0.41,
  confint = TRUE,
  alpha = 0.05,
  bootstraps = 2500,
  digits = 2,
  message = FALSE
)
}
}
\seealso{
\code{\link{eval_acc_parity}}, \code{\link{eval_bs_parity}}, \code{\link{eval_pred_parity}}
}
