% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMultiBin.R
\name{EstMLELMBin}
\alias{EstMLELMBin}
\title{Estimating the probability of success and theta for Lovinson Multiplicative Binomial
Distribution}
\usage{
EstMLELMBin(x,freq,p,phi)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{p}{single value for probability of success.}

\item{phi}{single value for phi parameter.}
}
\value{
\code{EstMLELMBin} here is used as a input parameter for the \code{mle2} function of \pkg{bbmle} package
therefore output is of class of mle2.
}
\description{
The function will estimate the probability of success and phi parameter using the
maximum log likelihood method for the Lovinson Multiplicative Binomial distribution when the binomial random
variables and corresponding frequencies are given.
}
\details{
\deqn{freq \ge 0}
\deqn{x = 0,1,2,..}
\deqn{0 < p < 1}
\deqn{0 < phi }
}
\examples{
No.D.D=0:7         #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)    #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters=suppressWarnings(bbmle::mle2(EstMLELMBin,start = list(p=0.5,phi=15),
           data = list(x=No.D.D,freq=Obs.fre.1)))

bbmle::coef(parameters)           #extracting the parameters

}
\references{
Elamir, E.A., 2013. Multiplicative-Binomial Distribution: Some Results on
Characterization, Inference and Random Data Generation. Journal of Statistical
Theory and Applications, 12(1), pp.92-105.
}
\seealso{
\code{\link[bbmle]{mle2}}
}
