% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{fm_generate_colors}
\alias{fm_generate_colors}
\title{Generate text RGB color specifications.}
\usage{
fm_generate_colors(
  color,
  color.axis = NULL,
  color.n = 512,
  color.palette = cm.colors,
  color.truncate = FALSE,
  alpha = NULL
)
}
\arguments{
\item{color}{\code{character}, \code{matrix} or \code{vector}}

\item{color.axis}{The min/max limit values for the color mapping.}

\item{color.n}{The number of colors to use in the color palette.}

\item{color.palette}{A color palette function.}

\item{color.truncate}{If \code{TRUE}, truncate the colors at the color axis
limits.}

\item{alpha}{Transparency/opaqueness values.}
}
\value{
A list with character vector \code{colors} and numeric vector \code{alpha}
}
\description{
Generates a text RGB color specification matrix based on a color palette.
}
\examples{
fm_generate_colors(1:4, color.axis = c(1, 4))

}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
\keyword{internal}
