% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_1d.R
\name{fm_mesh_1d}
\alias{fm_mesh_1d}
\title{Make a 1D mesh object}
\usage{
fm_mesh_1d(
  loc,
  interval = range(loc),
  boundary = NULL,
  degree = 1,
  free.clamped = FALSE,
  ...
)
}
\arguments{
\item{loc}{B-spline knot locations.}

\item{interval}{Interval domain endpoints.}

\item{boundary}{Boundary condition specification.  Valid conditions are
\code{c('neumann', 'dirichlet', 'free', 'cyclic')}.  Two separate values can
be specified, one applied to each endpoint.}

\item{degree}{The B-spline basis degree.  Supported values are 0, 1, and 2.}

\item{free.clamped}{If \code{TRUE}, for \code{'free'} boundaries, clamp the
basis functions to the interval endpoints.}

\item{\dots}{Additional options, currently unused.}
}
\value{
An \code{fm_mesh_1d} object
}
\description{
Create a \code{fm_mesh_1d} object.
}
\examples{
if (require("ggplot2")) {
  m1 <- fm_mesh_1d(c(1, 2, 3, 5, 8, 10),
    boundary = c("neumann", "free")
  )
  weights <- c(2, 3, 6, 3, 4, 7)
  ggplot() +
    geom_fm(data = m1, xlim = c(0.5, 11), weights = weights)

  m2 <- fm_mesh_1d(c(1, 2, 3, 5, 8, 10),
    boundary = c("neumann", "free"),
    degree = 2
  )
  ggplot() +
    geom_fm(data = m2, xlim = c(0.5, 11), weights = weights)

  # The knot interpretation is different for degree=2 and degree=1 meshes:
  ggplot() +
    geom_fm(data = m1, xlim = c(0.5, 11), weights = weights) +
    geom_fm(data = m2, xlim = c(0.5, 11), weights = weights)

  # The `mid` values are the representative basis function midpoints,
  # and can be used to connect degree=2 and degree=1 mesh interpretations:
  m1b <- fm_mesh_1d(m2$mid,
    boundary = c("neumann", "free"),
    degree = 1
  )
  ggplot() +
    geom_fm(data = m2, xlim = c(0.5, 11), weights = weights) +
    geom_fm(data = m1b, xlim = c(0.5, 11), weights = weights)
}

}
\seealso{
Other object creation and conversion: 
\code{\link{fm_as_collect}()},
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_collect}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
\concept{object creation and conversion}
