% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_underline.R
\name{add_underline}
\alias{add_underline}
\title{Add underline to cells}
\usage{
add_underline(
  plot,
  row = NULL,
  col = NULL,
  part = c("body", "header"),
  gp = gpar(lwd = 2)
)
}
\arguments{
\item{plot}{A forest plot object.}

\item{row}{A numeric value or vector indicating row number to add underline.
This is corresponding to the data row number. Remember to account for any
text inserted. This will be ignored if the \code{part} is  "header" and the
underline will be drawn under the header column.}

\item{col}{A numeric value or vector indicating the columns to add underline.}

\item{part}{The underline will be added to \code{"body"} (default) or
\code{"header"}.}

\item{gp}{An object of class \code{"gpar"}, graphical parameter to be passed
to \code{\link[grid]{segmentsGrob}}.}
}
\value{
A \code{\link[gtable]{gtable}} object.
}
\description{
This function can be used to add underline to cells.
}
\seealso{
\code{\link[grid]{gpar}} \code{\link[grid]{segmentsGrob}} \code{\link[gtable]{gtable_add_grob}}
}
