% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_text.r
\name{add_text}
\alias{add_text}
\title{Add text to forest plot}
\usage{
add_text(
  plot,
  text,
  row = NULL,
  col = NULL,
  part = c("body", "header"),
  just = c("center", "left", "right"),
  gp = gpar(),
  padding = unit(1, "mm"),
  parse = FALSE
)
}
\arguments{
\item{plot}{A forest plot object.}

\item{text}{A character or expression vector, see \code{\link[grid]{textGrob}}.}

\item{row}{Row to add the text, this will be ignored if the \code{part} is
"header".}

\item{col}{A numeric value or vector indicating the columns the text will be
added. The text will span over the column if a vector is given.}

\item{part}{Part to add text, body (default) or header.}

\item{just}{The justification of the text, \code{"center"} (default),
\code{"left"} or \code{"right"}.}

\item{gp}{An object of class \code{"gpar"}, this is the graphical parameter
settings of the text. See \code{\link[grid]{gpar}}.}

\item{padding}{Padding of the text, default is \code{unit(1, "mm")}}

\item{parse}{Logical, behaviour for parsing text as plotmath, see
\code{\link[grDevices]{plotmath}}}
}
\value{
A \code{\link[gtable]{gtable}} object.
}
\description{
This function can be used to add text to forest plot. The text can be span to
multiple rows and columns. The height of the row will be changed accordingly
if the text is added to only one row. The width of the text may exceeds the
columns provided if the text is too long.
}
\seealso{
\code{\link[gtable]{gtable}} \code{\link[grid]{gpar}} \code{\link[grid]{textGrob}}
\code{\link[gtable]{gtable_add_grob}}
}
