% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_release_tables.R
\name{fredr_release_tables}
\alias{fredr_release_tables}
\title{Get release table trees for a given release}
\usage{
fredr_release_tables(release_id = NULL, element_id = NULL,
  include_observation_values = NULL, observation_date = NULL)
}
\arguments{
\item{release_id}{An integer ID of the release. \emph{Required parameter.}}

\item{element_id}{An integer ID for the desired release table element.}

\item{include_observation_values}{A boolean indicating if observations should
be returned with the release table element. Observations will only be returned
for a series type element.  Default is \code{FALSE}.}

\item{observation_date}{A \code{Date} indicating which observation date to include
with the release table.  Default is \code{9999-12-31} (latest date available).}
}
\value{
A \code{tibble} object with nested results.
}
\description{
You can go directly to the tree structure by passing the appropriate
\code{element_id}. You may also use a drill-down approach to start at the root
(top most) element by leaving the \code{element_id} off.
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/release_tables.html}{fred/release/tables}
}

\examples{
\donttest{
fredr_release_tables(release_id = 10L)

# Digging further into a release element
fredr_release_tables(release_id = 53L, element_id = 12886)
}
}
\seealso{
\code{\link[=fredr_releases]{fredr_releases()}}, \code{\link[=fredr_release_dates]{fredr_release_dates()}}, \code{\link[=fredr_releases_dates]{fredr_releases_dates()}},
\code{\link[=fredr_release]{fredr_release()}}, \code{\link[=fredr_release_series]{fredr_release_series()}}, \code{\link[=fredr_release_sources]{fredr_release_sources()}},
\code{\link[=fredr_release_tags]{fredr_release_tags()}}, \code{\link[=fredr_release_related_tags]{fredr_release_related_tags()}}
}
