% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_brand.R
\name{write_brand}
\alias{write_brand}
\title{Write Brand YAML for 'Quarto' Projects}
\usage{
write_brand(
  path = here::here(),
  restore_logos = TRUE,
  .initialize_proj = FALSE
)
}
\arguments{
\item{path}{Character string. Path to the project directory.}

\item{restore_logos}{Logical. Restore logo content from system configuration.
Default is `TRUE`.}

\item{.initialize_proj}{Logical. TRUE only if starting a 
\code{froggeR::quarto_project()}.}
}
\value{
Invisibly returns `NULL` after creating or updating the `_brand.yml` file.
}
\description{
This function creates or updates the `_brand.yml` file in a Quarto project
directory if they exist in the config path.
}
\details{
The function will attempt to use the current froggeR settings from the config path. If
no global configurations exist, a template `_brand.yml` will be created.
}
\examples{

# Write the _brand.yml file
if (interactive()) {
  temp_dir <- tempdir()
  write_brand(temp_dir)
}

}
