% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{FRTM_PhaseII}
\alias{FRTM_PhaseII}
\title{Phase II of the FRTM method.}
\usage{
FRTM_PhaseII(data_oc, mod_phaseI, ncores = 1)
}
\arguments{
\item{data_oc}{A list containing the following arguments: \code{x_err} a list containing the discrete observations for each curve to be monitored; \code{grid_i} a list of vector of time points where the curves to be monitored are sampled.}

\item{mod_phaseI}{An object of class \code{mod_phaseI_FRTM} obtained as output of the function  \code{FRTM_PhaseI}.}

\item{ncores}{If \code{ncores}>1, then parallel computing is used, with \code{ncores} cores. Default is 1.}
}
\value{
A list containing the following arguments:

\code{T2_fd} List of \eqn{T^{2}} functions for each observation.

\code{SPE_fd} List of SPE functions for each observation.

\code{CL_T2} Control limit of  the Hotelling's \eqn{T^{2}} control chart.

\code{CL_SPE} Control limit of  the SPE control chart.

\code{x_err} A list containing the discrete observations for each curve.

\code{grid_i} A list of vector of time points where the curves  are sampled.

\code{x_list_smooth} Smooth curves.

\code{mod_phaseI} An object of class \code{mod_phaseI_FRTM} obtained as output of the function  \code{FRTM_PhaseI}.
}
\description{
This function implements the monitoring phase (Phase II) of FRTM method.
}
\examples{
library(funcharts)
data <- simulate_data_FRTM(n_obs = 20)

data_oc <-
  simulate_data_FRTM(
    n_obs = 2,
    scenario = "1",
    shift = "OC_h",
    severity = 0.5
  )

lambda <- 10 ^ -5
max_x <- max(unlist(data$grid_i))
seq_t_tot <- seq(0, 1, length.out = 30)[-1]
seq_x <- seq(0.1, max_x, length.out = 10)


\donttest{
  mod_phaseI_FRTM <- FRTM_PhaseI(
    data_tra =  data,
    control.FDTW = list(
      M = 30,
      N = 30,
      lambda = lambda,
      seq_t = seq_t_tot,
      iter_tem = 1,
      iter = 1
    ),
    control.rtr = list(seq_x = seq_x)
  )
  mod_phaseII_FRTM <- FRTM_PhaseII(data_oc = data_oc , mod_phaseI = mod_phaseI_FRTM)

  plot(mod_phaseI_FRTM)
  plot(mod_phaseII_FRTM)
}

}
\references{
Centofanti, F., A. Lepore, M. Kulahci, and M. P. Spooner (2024).
Real-time monitoring of functional data. \emph{Journal of Quality Technology}, 57(2):135--152,
doi:https://doi.org/10.1080/00224065.2024.2430978.
}
