% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_t.R
\name{delta_t}
\alias{delta_t}
\title{Return the value of delta-T in units of seconds}
\usage{
delta_t(year, month)
}
\arguments{
\item{year}{Type in the year (integer between -1999 and 3000).}

\item{month}{Type in the month (integer between 1 and 12).}
}
\value{
\code{numeric}: vector of numeric values
}
\description{
Converting the Coordinated Universal Time (UTC) to the Ephemeris Time (ET) is complex.
It is due to the unpredictable nature of the Earth's rotation, which is the basis for
UTC, whereas ET was based on the more uniform orbital motion of the Earth around the
Sun. The key to converting between these time scales lies in a value known as delta-T,
which is the difference between a uniform time scale and one based on
Earth's rotation. The conversion is handled as:
ET = UTC + deltaT
However, delta-T is not a constant value and cannot be calculated using a simple
formula. The delta-T values are derived from the historical records and from direct
observations. A series of polynomial expressions have been created to simplify the
evaluation of delta-T. The calculated values are valid for the years from -1999 to +3000.
}
\details{
More details:
Morrison, L. and Stephenson, F. R., "Historical Values of the Earth's Clock Error delta-T
and the Calculation of Eclipses", J. Hist. Astron., Vol. 35 Part 3, August 2004,
No. 120, pp 327-336 (2004)
Stephenson F.R., Historical Eclipses and Earth's Rotation, Cambridge Univ. Press, 1997
}
\examples{
delta_t(1999, 10)
delta_t(c(-200, 1610, 2030), c(1, 10, 12))
}
