% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bool-generics.R, R/Bool-methods.R
\docType{methods}
\name{And}
\alias{And}
\alias{`&`}
\alias{And,.compoundExpr-method}
\alias{&,.compoundExpr,.compoundExpr-method}
\title{And.}
\usage{
And(object, ...)

\S4method{And}{.compoundExpr}(object, ...)

\S4method{&}{.compoundExpr,.compoundExpr}(e1, e2)
}
\arguments{
\item{object}{The first object within the AND expression}

\item{...}{Additional objects to include within the AND expression.}

\item{e1}{first expression}

\item{e2}{second expression}
}
\value{
an object of class \code{andExpr}
}
\description{
AND two or more ganalytics expressions together.
}
\section{Methods (by class)}{
\itemize{
\item \code{.compoundExpr}: AND two or more expressions.

\item \code{e1 = .compoundExpr,e2 = .compoundExpr}: AND two expressions.
}}

\examples{
purchased_on_mobile <- Expr(~deviceCategory == "mobile") & Expr(~transactions > 0)

}
\seealso{
Other boolean functions: \code{\link{Not}},
  \code{\link{Or}}, \code{\link{xor}}
}
\concept{boolean functions}
