% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bool-generics.R, R/Bool-methods.R
\docType{methods}
\name{Or}
\alias{Or}
\alias{`|`}
\alias{Or,.compoundExpr-method}
\alias{|,.compoundExpr,.compoundExpr-method}
\title{Or.}
\usage{
Or(object, ...)

\S4method{Or}{.compoundExpr}(object, ...)

\S4method{|}{.compoundExpr,.compoundExpr}(e1, e2)
}
\arguments{
\item{object}{The first object to include within the OR expression.}

\item{...}{Additional objects to include within the OR expression.}

\item{e1}{first expression}

\item{e2}{second expression}
}
\value{
An object of class orExpr.
}
\description{
OR two or more expressions.
}
\section{Methods (by class)}{
\itemize{
\item \code{.compoundExpr}: OR two or more expressions.

\item \code{e1 = .compoundExpr,e2 = .compoundExpr}: OR two expressions.
}}

\examples{
mobile_or_tablet <- Expr(~deviceCategory == "mobile") | Expr(~deviceCategory == "tablet")
converted <- Expr(~goalCompletionsAll > 0) | Expr(~transactions > 0)

}
\seealso{
Other boolean functions: \code{\link{And}},
  \code{\link{Not}}, \code{\link{xor}}
}
\concept{boolean functions}
