% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_coords.R
\name{spectral_coords}
\alias{spectral_coords}
\title{Spectral Coordinates for Graph Drawing}
\usage{
spectral_coords(adj_mat)
}
\arguments{
\item{adj_mat}{A symmetric adjacency matrix or sparse matrix representing an undirected graph.}
}
\value{
A matrix where each row represents the spectral coordinates of a node in the graph.
}
\description{
Calculates the spectral coordinates of a graph using the two smallest non-zero eigenvalues of the graph Laplacian.
}
\references{
Chung, F. R. K. (1997). Spectral Graph Theory. American Mathematical Soc.

Hall, K. M. (1970). An r-dimensional quadratic placement algorithm. Management science, 17(3), 219-229.
}
\seealso{
\code{\link{plot_graph}}, \code{\link{plot_signal}}
}
