% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_wk2wk}
\alias{g_wk2wk}
\title{Geometry WKB/WKT conversion}
\usage{
g_wk2wk(geom, as_iso = FALSE, byte_order = "LSB")
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors to convert
to WKT, or a character vector containing one or more WKT strings to
convert to WKB.}

\item{as_iso}{Logical value, \code{TRUE} to export as ISO WKB/WKT (ISO 13249
SQL/MM Part 3), or \code{FALSE} (the default) to export as "Extended WKB/WKT"
(see Note).}

\item{byte_order}{Character string specifying the byte order when converting
to WKB. One of \code{"LSB"} (the default) or \code{"MSB"} (uncommon).}
}
\value{
For input of a WKB raw vector or list of raw vectors, returns a character
vector of WKT strings, with length of the returned vector equal to the
number of input raw vectors. For input of a single WKT string, returns a raw
vector of WKB. For input of a character vector containing more than one WKT
string, returns a list of WKB raw vectors, with length of the returned list
equal to the number of input strings.
}
\description{
\code{g_wk2wk()} converts geometries between Well Known Binary (WKB) and
Well Known Text (WKT) formats. A geometry given as a raw vector of WKB will
be converted to a WKT string, while a geometry given as a WKT string will be
converted to a WKB raw vector. Input may also be a list of WKB raw vectors
or a character vector of WKT strings.
}
\note{
With \code{as_iso = FALSE} (the default), geometries are exported as extended
dimension (Z) WKB/WKT for types Point, LineString, Polygon, MultiPoint,
MultiLineString, MultiPolygon and GeometryCollection. For other geometry
types, it is equivalent to ISO.

When the return value is a list of WKB raw vectors, an element in the
returned list will contain \code{NULL} (and a warning emitted) if the
corresponding input string was \code{NA} or empty (\code{""}).

When input is a list of WKB raw vectors, a corresponding element in the
returned character vector will be \code{NA} if the input was a raw vector of
length \code{0} (i.e., \code{raw(0)}). If an input list element is not a raw vector,
then the corresponding element in the returned character vector will also
be \code{NA}. A warning is emitted in each case.
}
\examples{
wkt <- "POINT (-114 47)"
wkb <- g_wk2wk(wkt)
str(wkb)
g_wk2wk(wkb)
}
\seealso{
GEOS reference for geometry formats:\cr
\url{https://libgeos.org/specifications/}
}
