% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpartdisc.R
\name{rpart_disc}
\alias{rpart_disc}
\title{discretization of variables based on recursive partitioning}
\usage{
rpart_disc(formula, data, ...)
}
\arguments{
\item{formula}{A formula.}

\item{data}{A data.frame or tibble of observation data.}

\item{...}{(optional) Other arguments passed to \code{rpart::rpart()}.}
}
\value{
A vector that being discretized.
}
\description{
discretization of variables based on recursive partitioning
}
\examples{
data('ndvi')
rpart_disc(NDVIchange ~ ., data = ndvi)

}
\references{
Luo, P., Song, Y., Huang, X., Ma, H., Liu, J., Yao, Y., & Meng, L. (2022). Identifying determinants of
spatio-temporal disparities in soil moisture of the Northern Hemisphere using a geographically optimal
zones-based heterogeneity model. ISPRS Journal of Photogrammetry and Remote Sensing: Official
Publication of the International Society for Photogrammetry and Remote Sensing (ISPRS), 185, 111–128.
https://doi.org/10.1016/j.isprsjprs.2022.01.009
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
