% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_snps.R
\name{screen_snps}
\alias{screen_snps}
\title{Reading and screening SNPs from .raw file and}
\usage{
screen_snps(rawFile, mapFile = "", phenotype, pValMax = 0.05,
  chunkSize = 100, verbose = TRUE)
}
\arguments{
\item{rawFile}{character, name of .raw file}

\item{mapFile}{character, name of .map file}

\item{phenotype}{numeric vector or an object of class \code{\link{phenotypeData}}}

\item{pValMax}{numeric, p-value threshold value used for screening}

\item{chunkSize}{integer, number of snps that will be processed together.
The bigger chunkSize is, the faster function works but
computer might run out of RAM}

\item{verbose}{if TRUE (default) information about progress is printed}
}
\value{
object of class \code{\link{screeningResult}}
}
\description{
Reading .raw file that was previously exported from PLINK - see details.
Additional information about SNP mapping is read from .map file.
}
\details{
\strong{Exporting data from PLINK}
To import data to R, it needs to be exported from
PLINK using the option "--recodeAD"
The PLINK command should therefore look like
\code{plink --file input --recodeAD --out output}.
For more information, please refer to:
\url{http://pngu.mgh.harvard.edu/~purcell/plink/dataman.shtml}
}

