% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.R
\name{git_commit}
\alias{git_commit}
\alias{git_commit_all}
\alias{git_commit_info}
\alias{git_commit_id}
\alias{git_commit_stats}
\alias{git_commit_descendant_of}
\alias{git_add}
\alias{git_rm}
\alias{git_status}
\alias{git_conflicts}
\alias{git_ls}
\alias{git_log}
\alias{git_stat_files}
\title{Stage and commit changes}
\usage{
git_commit(message, author = NULL, committer = NULL, repo = ".")

git_commit_all(message, author = NULL, committer = NULL, repo = ".")

git_commit_info(ref = "HEAD", repo = ".")

git_commit_id(ref = "HEAD", repo = ".")

git_commit_stats(ref = "HEAD", repo = ".")

git_commit_descendant_of(ancestor, ref = "HEAD", repo = ".")

git_add(files, force = FALSE, repo = ".")

git_rm(files, repo = ".")

git_status(staged = NULL, pathspec = NULL, repo = ".")

git_conflicts(repo = ".")

git_ls(repo = ".", ref = NULL)

git_log(ref = "HEAD", max = 100, after = NULL, repo = ".")

git_stat_files(files, ref = "HEAD", repo = ".")
}
\arguments{
\item{message}{a commit message}

\item{author}{A \link{git_signature} value, default is \code{\link[=git_signature_default]{git_signature_default()}}.}

\item{committer}{A \link{git_signature} value, default is same as \code{author}}

\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}

\item{ref}{revision string with a branch/tag/commit value}

\item{ancestor}{a reference to a potential ancestor commit}

\item{files}{vector of paths relative to the git root directory.
Use \code{"."} to stage all changed files.}

\item{force}{add files even if in gitignore}

\item{staged}{return only staged (TRUE) or unstaged files (FALSE).
Use \code{NULL} or \code{NA} to show both (default).}

\item{pathspec}{character vector with paths to match}

\item{max}{lookup at most latest n parent commits}

\item{after}{date or timestamp: only include commits starting this date}
}
\value{
\itemize{
\item \code{git_status()}, \code{git_ls()}: A data frame with one row per file
\item \code{git_log()}: A data frame with one row per commit
\item \code{git_commit()}, \code{git_commit_all()}: A SHA
}
}
\description{
To commit changes, start by \emph{staging} the files to be included in the commit
using \code{git_add()} or \code{git_rm()}. Use \code{git_status()} to see an overview of
staged and unstaged changes, and finally \code{git_commit()} creates a new commit
with currently staged files.

\code{git_commit_all()} is a convenience function that automatically stages and
commits all modified files. Note that \code{git_commit_all()} does \strong{not} add
new, untracked files to the repository. You need to make an explicit call to
\code{git_add()} to start tracking new files.

\code{git_log()} shows the most recent commits and \code{git_ls()} lists all the files
that are being tracked in the repository. \code{git_stat_files()}
}
\examples{
oldwd <- getwd()
repo <- file.path(tempdir(), "myrepo")
git_init(repo)
setwd(repo)

# Set a user if no default
if(!user_is_configured()){
  git_config_set("user.name", "Jerry")
  git_config_set("user.email", "jerry@gmail.com")
}

writeLines(letters[1:6], "alphabet.txt")
git_status()

git_add("alphabet.txt")
git_status()

git_commit("Start alphabet file")
git_status()

git_ls()

git_log()

cat(letters[7:9], file = "alphabet.txt", sep = "\n", append = TRUE)
git_status()

git_commit_all("Add more letters")

# cleanup
setwd(oldwd)
unlink(repo, recursive = TRUE)
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_ignore}},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_reset}()},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}},
\code{\link{git_worktree}}
}
\concept{git}
