% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{crs_eqc}
\alias{crs_eqc}
\title{Coordinate reference system for spatial computations}
\usage{
crs_eqc(latitude = 0, units = "km")
}
\arguments{
\item{latitude}{The latitude of true scale (the \code{proj} parameter
\code{lat_ts}). This is the latitude where the scale is not distorted by
the projection.}

\item{units}{Base length unit (e.g. \code{"km"} or \code{"mi"}).
See \code{\link[ggmapinset:configure_inset]{ggmapinset::configure_inset()}} for supported values.}
}
\value{
CRS object from \code{sf}.
}
\description{
\code{crs_eqc()} gives a CRS that can be used for e.g. computing centroids or
distances.
It is an equidistant cylindrical system that by does not distort latitudes
near \code{latitude}. The CRS is in units of kilometres by default.
}
\examples{
# Sydney, Australia has a latitude of 33.87 S so this CRS will be suitable
# for computations close to there:
crs_eqc(latitude = -33.87)
}
