% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_boundaries.R
\name{geom_boundaries}
\alias{geom_boundaries}
\title{Map feature boundaries}
\usage{
geom_boundaries(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf_inset",
  position = "identity",
  ...,
  feature_type = NULL,
  inset = NA,
  map_base = "normal",
  map_inset = "auto",
  na.rm = FALSE,
  outline.aes = list(colour = "#666666"),
  show.legend = NA,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping, stat, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.}

\item{data}{Ignored (this geometry always uses the registered geographic data).}

\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{inset}{Inset configuration; see \code{\link[ggmapinset:configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[ggmapinset:coord_sf_inset]{coord_sf_inset()}}).}

\item{map_base}{Controls the layer with the base map. Possible values are
\code{"normal"} to create a layer as though the inset were not specified,
\code{"clip"} to create a layer with the inset viewport cut out, and
\code{"none"} to prevent the insertion of a layer for the base map.}

\item{map_inset}{Controls the layer with the inset map. Possible values are
\code{"auto"} to choose the behaviour based on whether \code{inset} is specified,
\code{"normal"} to create a layer with the viewport cut out and transformed, and
\code{"none"} to prevent the insertion of a layer for the viewport map.}

\item{outline.aes}{A list to override the aesthetics for the outline of the map.
This has no effect if the map wasn't registered with a separate outline.}
}
\value{
A ggplot layer.
}
\description{
Retrieves the full map data from \code{{cartographer}} and plots the boundaries.
As well as the chosen feature boundaries, the outline of the map is
drawn separately if one has been registered with the map data, with the
possibility to override its aesthetics.
}
\examples{
library(ggplot2)

ggplot() +
  geom_boundaries(feature_type = "sf.nc")
}
