% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-hdr-rug.R
\name{geom_hdr_rug}
\alias{geom_hdr_rug}
\title{Rug plot for the highest density region}
\usage{
geom_hdr_rug(
  mapping = NULL,
  data = NULL,
  stat = "hdr",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  sides = "bl",
  rug_width = unit(0.03, "npc"),
  prob = c(0.5, 0.95, 0.99)
)
}
\arguments{
\item{mapping}{Default: NULL}

\item{data}{data}

\item{stat}{stat}

\item{position}{Default: "identity"}

\item{...}{...}

\item{na.rm}{Default: FALSE}

\item{show.legend}{Default: NA}

\item{inherit.aes}{Default: TRUE}

\item{sides}{position to put rugs}

\item{rug_width}{width of rugs, Default: unit(0.03, "npc")}

\item{prob}{PARAM_DESCRIPTION, Default: c(0.5, 0.95, 0.99)}
}
\value{
Calculates and plots the rug plot of highest density regions.
}
\description{
rug visualization for HDR plot
}
\examples{
library(ggplot2)

ggplot(faithful, aes(x = waiting, y = eruptions)) +
  geom_point() +
  geom_hdr_rug()
}
