% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_contour_interactive.R
\name{geom_contour_interactive}
\alias{geom_contour_interactive}
\alias{geom_contour_filled_interactive}
\title{Create interactive 2d contours of a 3d surface}
\usage{
geom_contour_interactive(...)

geom_contour_filled_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
These geometries are based on \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}
and \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour_filled()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive contours to a ggplot -------
library(ggplot2)
library(ggiraph)

v <- ggplot(faithfuld, aes(waiting, eruptions, z = density))
p <- v +
  geom_contour_interactive(aes(
    colour = after_stat(level),
    tooltip = paste("Level:", after_stat(level))
  ))
x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}

if (packageVersion("grid") >= numeric_version("3.6")) {
  p <- v +
    geom_contour_filled_interactive(aes(
      colour = after_stat(level),
      fill = after_stat(level),
      tooltip = paste("Level:", after_stat(level))
    ))
  x <- girafe(ggobj = p)
  if (interactive()) print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
