% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettify.R
\name{prettify}
\alias{prettify}
\title{Prettify tokenized output}
\usage{
prettify(tbl, into = get_dict_features("ipa"), col_select = seq_along(into))
}
\arguments{
\item{tbl}{A data.frame that has feature column to be prettified.}

\item{into}{Character vector that is used as column names of
features.}

\item{col_select}{Character or integer vector that will be kept
in prettified features.}
}
\value{
A data.frame.
}
\description{
Turns a single character column into features
separating with delimiter.
}
\examples{
\dontrun{
df <- tokenize(
  data.frame(
    doc_id = seq_along(audubon::polano[5:8]),
    text = audubon::polano[5:8]
  )
)
prettify(df, col_select = 1:3)
prettify(df, col_select = c(1, 3, 6))
prettify(df, col_select = c("POS1", "Original"))
}
}
