% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nelder.R
\name{nelder}
\alias{nelder}
\title{Generates a block experimental structure using Nelder's formula}
\usage{
nelder(formula)
}
\arguments{
\item{formula}{A model formula. See details}
}
\value{
A list with the first member being the data frame
}
\description{
Generates a data frame expressing a block experimental structure using Nelder's formula
}
\details{
Nelder (1965) suggested a simple notation that could express a large variety of different blocked designs. 
The function `nelder()` that generates a data frame of a design using the notation. 
There are two operations:
 
`>` (or \eqn{\to} in Nelder's notation) indicates "clustered in".

`*` (or \eqn{\times} in Nelder's notation) indicates a crossing that generates all combinations of two factors.

The implementation of this notation includes a string indicating the name of the variable and a number for the number of levels, 
such as `abc(12)`. So for example `~cl(4) > ind(5)` means in each of five levels of `cl` there are five levels of `ind`, and 
the individuals are different between clusters. The formula `~cl(4) * t(3)` indicates that each of the four levels of `cl` are 
observed for each of the three levels of `t`. Brackets are used to indicate the order of evaluation. Some specific examples:

`~person(5) * time(10)`: A cohort study with five people, all observed in each of ten periods `time`

`~(cl(4) * t(3)) > ind(5)`: A repeated-measures cluster study with four clusters (labelled `cl`), each observed in each time 
period `t` with cross-sectional sampling and five indviduals (labelled `ind`) in each cluster-period.

`~(cl(4) > ind(5)) * t(3)`: A repeated-measures cluster cohort study with four clusters (labelled `cl`) wth five 
individuals per cluster, and each cluster-individual combination is observed in each time period `t`.

`~((x(100) * y(100)) > hh(4)) * t(2)`: A spatio-temporal grid of 100x100 and two time points, with 4  households per spatial 
grid cell.
}
\examples{
nelder(~(j(4) * t(5)) > i(5))
nelder(~person(5) * time(10))
}
