% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundaries.R
\name{boundaries}
\alias{boundaries}
\alias{date_start}
\alias{date_end}
\title{Access the bounding dates of a grates object}
\usage{
date_start(x)

date_end(x)
}
\arguments{
\item{x}{grouped date vector.}
}
\value{
The requested start and end dates for each element in the input.
}
\description{
Utility functions for accessing the boundary dates for each element of
a grates object.
}
\examples{
dates <- as.Date("2020-01-01") + 1:9
week <- as_isoweek(dates)
date_start(week)
date_end(week)

period <- as_period(dates, n = 3)
date_start(period)
date_end(period)

}
