% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ae_focus.R
\name{tbl_ae_focus}
\alias{tbl_ae_focus}
\title{Tabulate AE Focused (Dichotomous) Summaries}
\usage{
tbl_ae_focus(
  data,
  include,
  id,
  ae,
  soc = NULL,
  strata = NULL,
  label = NULL,
  id_df = NULL,
  statistic = "{n} ({p})",
  digits = NULL,
  sort = NULL,
  zero_symbol = "—"
)
}
\arguments{
\item{data}{Data frame}

\item{include}{Vector of column names to summarize. Column names may be
quoted or unquoted. All columns must be class 'logical'.}

\item{id}{Variable name of the patient ID}

\item{ae}{Variable name of the adverse event column}

\item{soc}{Variable name of the system organ class column}

\item{strata}{Variable to stratify results by, e.g. report AEs summaries
by treatment group}

\item{label}{A named list of labels that will be applied in the
resulting table. Names must be those passed in \verb{include=}. Default is
NULL, and either the label attribute or the column name will be used.}

\item{id_df}{Optional data frame of complete id values and strata to achieve correct
base n for the situation in which not all subjects experience adverse events. See
\code{\link{df_patient_characteristics}} for an example \code{id_df} that pairs with
\code{\link{df_adverse_events}}.}

\item{statistic}{String indicating the statistics that will be reported.
The default is \code{"{n} ({p})"}}

\item{digits}{Specifies the number of decimal places to round the summary statistics.
By default integers are shown to zero decimal places, and percentages are
formatted with \code{style_percent()}. If you would like to modify either
of these, pass a vector of integers indicating the number of decimal
places to round the statistics. For example, if the statistic being
calculated is \code{"{n} ({p}\%)"} and you want the percent rounded to
2 decimal places use \code{digits = c(0, 2)}.
User may also pass a styling function: \code{digits = style_sigfig}}

\item{sort}{Controls order of AEs and SOCs in output table.
The default is \code{NULL}, where AEs and SOCs are sorted alphanumerically
(and factors sorted according to their factor level).
Use \code{sort = "ae"} to sort AEs in decreasing frequency order, \code{sort = "soc"}
to sort SOCs in decreasing order, and \code{sort = c("ae", "soc")} to sort both.
AEs are sorted within SOC.}

\item{zero_symbol}{String used to represent cells with zero counts. Default
is the em-dash (\code{"\\U2014"}). Using \code{zero_symbol = NULL} will print the
zero count statistics, e.g. \code{"0 (0)"}}
}
\value{
a 'tbl_ae_focus' object
}
\description{
Summarize dichotomous AE data. For example, report the
rate of patients that have an AE of Grade 3 or higher.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_ae_focus_ex1.png}{options: width=75\%}}
}

\examples{
\donttest{
# Example 1 -----------------------------------------------------------------
tbl_ae_focus_ex1 <-
  df_adverse_events \%>\%
  tbl_ae_focus(
    include = c(any_complication, grade3_complication),
    id = patient_id,
    ae = adverse_event,
    soc = system_organ_class,
    label =
      list(any_complication = "Any Grade Complication",
           grade3_complication = "Grade 3+ Complication")
  ) \%>\%
  bold_labels()
  }
}
