% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.assess.R
\name{plot.assess}
\alias{plot.assess}
\title{Prediction plot of treatment and control groups for DID and ITS models}
\usage{
\method{plot}{assess}(x, y, xlim = NULL, ylim = NULL, add.legend = NULL, ...)
}
\arguments{
\item{x}{assess object. Either difference-in-difference or interrupted time series model with no covariate adjustment.}

\item{y}{type of model, specify either 'DID' (difference-in-difference) or 'ITS' (interrupted time series). Will not accept other models.}

\item{xlim}{specify plot's x-axis limits with a 2 value vector.}

\item{ylim}{specify plot's y-axis limits with a 2 value vector.}

\item{add.legend}{add a legend by selecting the location as "bottomright", "bottom", "bottomleft",
"left", "topleft", "top", "topright", "right", "center". No legend if nothing selected.}

\item{...}{additional arguments.}
}
\value{
plot of partial predictions for treatment and control groups.
}
\description{
Provides partial prediction plots for treatment and control groups from difference-in-difference (DID)
and interrupted time series (ITS) models. The graph will produce lines for treatment/intervention and
control groups to gain understanding through a visual representation of the regression coefficients.
The treatment/intervention group is represented with a blue line, the control group is represented with
a red line, and the counterfactual line, when available, is a dashed line.
}
\examples{
am2 <- assess(formula= los ~ ., data=hosprog, intervention = "program",
topcode =NULL, int.time="month", regression="none", treatment= 5,
interrupt=c(5,9), did="many", its="two", newdata=TRUE, propensity=NULL)
plot(am2, "DID", add.legend="bottomleft", ylim=c(2, 8))  #DID model
plot(am2, "ITS", add.legend="top", ylim=c(2, 8))         #ITS model
}
