% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryWO_data_frame.R
\name{summaryWO.data.frame}
\alias{summaryWO.data.frame}
\title{Win odds summary for a data frame}
\usage{
\method{summaryWO}{data.frame}(x, AVAL, TRTP, ref, GROUP = NULL, ...)
}
\arguments{
\item{x}{a data frame containing subject-level data.}

\item{AVAL}{variable in the data with ordinal analysis values.}

\item{TRTP}{the treatment variable in the data.}

\item{ref}{the reference treatment group.}

\item{GROUP}{an optional variable for grouping.}

\item{...}{additional parameters.}
}
\value{
a list containing the summary of wins, losses, and ties. It contains the following named objects:
\itemize{
\item summary a data frame containing number of wins, losses, and ties by treatment group and the overall number of comparisons.
\item summary_by_GROUP (if \code{GROUP} variable is specified) a summary data frame by \code{GROUP}.
\item WO calculated WO (win odds) and WP (win probability) and their standard errors.
}
}
\description{
Win odds summary for a data frame
}
\examples{
summaryWO(x = HCE3, AVAL = "AVAL", TRTP = "TRTP", ref = "P", GROUP = "GROUP")
}
\seealso{
\code{\link[=calcWO]{calcWO()}}, \code{\link[=summaryWO]{summaryWO()}}, \code{\link[=summaryWO.formula]{summaryWO.formula()}}, \code{\link[=summaryWO.hce]{summaryWO.hce()}}   methods.
}
