% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dTV_sample.R
\name{dTV_sample}
\alias{dTV_sample}
\title{The total variation distance between distributions}
\usage{
dTV_sample(S, j, A = NULL, base, lenA = NULL, A_pairs = NULL, x_S)
}
\arguments{
\item{S}{A numeric vector of positive integers (or \code{NULL}) representing
a set of past lags. The distributions from which this function will calculate the total
variation distance are conditioned on a fixed sequence indexed by \code{S}
(the user must also input the sequence through the argument \code{x_S}).}

\item{j}{A positive integer representing a lag in the \eqn{complement} of \code{S}.
The symbols indexed by \code{j} vary along the state space \code{A}, altering
the distribution through this single lag, and the size of this change is what
this function seeks to measure.}

\item{A}{A vector of unique nonnegative integers (state space) with at least
two elements. \code{A} represents the state space. You may leave \code{A=NULL}
(default) if you provide the function
with the arguments \code{lenA} and \code{A_pairs} (see \emph{Details} below).}

\item{base}{A data frame with sequences of elements from \code{A} and their transition
probabilities. \code{base} is meant to be an output from function \code{\link[=freqTab]{freqTab()}},
and must be structured as such. The data frame must contain all required transitions
conditioned on \code{x_S} (i.e. \code{length(A)^2} rows with sequence \code{x_S}).
See \emph{Details} section for further information.}

\item{lenA}{An integer \code{>= 2}, representing \code{length(A)}. Required if \code{A} is not
provided.}

\item{A_pairs}{A two-column matrix with all unique pairs of elements from \code{A}.
Required if \code{A} is not provided.}

\item{x_S}{A vector of length \code{length(S)} or \code{NULL}. If \code{S==NULL}, \code{x_S} will
be set to \code{NULL}. \code{x_S} represents a sequence of symbols from \code{A} indexed by
\code{S}. This sequence remains constant across the conditional distributions to be compared,
representing the fixed configuration of the past.}
}
\value{
A single-row matrix with one column per pair of distinct elements from
the state space \code{A} (so \code{choose(length(A), 2)} columns). Each entry
corresponds to the total variation distance between a pair of distributions,
conditioned on the same fixed past \code{x_S} (when \code{S} is not \code{NULL}),
differing only in the symbol indexed by \code{j}, which varies across all
distinct pairs of elements in \code{A}. When \code{S} is \code{NULL}, the row
name is the empty string \code{""}.
}
\description{
Calculates the total variation distance between distributions conditioned
in a given past sequence.
}
\details{
This function computes the total variation distance between distributions
found in \code{base}, which is expected to be the output of the function \code{\link[=freqTab]{freqTab()}}.
Therefore, \code{base} must follow a specific structure (e.g., column names must
match, and a column named qax_Sj, containing transition distributions, must be
present). For more details on the output structure of \code{\link[=freqTab]{freqTab()}}, refer to its
documentation.

The total-variation distance is computed as
\deqn{\tfrac{1}{2}\sum_{a \in \mathcal A} \left|
        \hat{p}(a | x_{-S}, x_{-j}=b) - \hat{p}(a| x_{-S}, x_{-j}=c)
      \right|,}
for each pair of symbols b, c in \code{A} using the empirical conditional
probabilities obtained from \code{\link{freqTab}} for the supplied \code{S}
and \code{j}.

If you provide the state space \code{A}, the function calculates:
\code{lenA <- length(A)} and \code{A_pairs <- t(utils::combn(A, 2))}.
Alternatively, you can input \code{lenA} and \code{A_pairs} directly and let
\code{A <- NULL}, which is useful in loops to improve efficiency.
}
\examples{
set.seed(1)
M <- MTDmodel(Lambda = c(1, 4), A = c(1, 2, 3), lam0 = 0.1)
X <- perfectSample(M, N = 400)
ct <- countsTab(X, d = 5)

# --- Case 1: S non-empty
pbase <- freqTab(S = c(1, 4), j = 2, A = c(1, 2, 3), countsTab = ct)
dTV_sample(S = c(1, 2), j = 4, A = c(1, 2, 3), base = pbase, x_S = c(2, 3))

# --- Case 2: S = NULL
pbase2 <- freqTab(S = NULL, j = 1, A = c(1, 2, 3), countsTab = ct)
dTV_sample(S = NULL, j = 1, A = c(1, 2, 3), base = pbase2)

}
