% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_logml_napp.R
\name{glm.logml.napp}
\alias{glm.logml.napp}
\title{Log marginal likelihood of a GLM under normalized asymptotic power prior (NAPP)}
\usage{
glm.logml.napp(post.samples, bridge.args = NULL)
}
\arguments{
\item{post.samples}{output from \code{\link[=glm.napp]{glm.napp()}} giving posterior samples of a GLM under the normalized asymptotic
power prior (NAPP), with an attribute called 'data' which includes the list of variables
specified in the data block of the Stan program.}

\item{bridge.args}{a \code{list} giving arguments (other than \code{samples}, \code{log_posterior}, \code{data}, \code{lb}, and \code{ub}) to
pass onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}
}
\value{
The function returns a \code{list} with the following objects

\describe{
\item{model}{"NAPP"}

\item{logml}{the estimated logarithm of the marginal likelihood}

\item{bs}{an object of class \code{bridge} or \code{bridge_list} containing the output from using \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}
to compute the logarithm of the marginal likelihood of the normalized asymptotic power prior (NAPP)}
}
}
\description{
Uses bridge sampling to estimate the logarithm of the marginal likelihood of a GLM under the
normalized asymptotic power prior (NAPP).
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg019)
  data(actg036)
  ## take subset for speed purposes
  actg019 = actg019[1:100, ]
  actg036 = actg036[1:50, ]
  data_list = list(currdata = actg019, histdata = actg036)
  formula = cd4 ~ treatment + age + race
  family = poisson('log')
  d.napp = glm.napp(
    formula = formula, family = family,
    data.list = data_list,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
  glm.logml.napp(
    post.samples = d.napp,
    bridge.args = list(silent = TRUE)
  )
}
}
\references{
Ibrahim, J. G., Chen, M., Gwon, Y., and Chen, F. (2015). The power prior: Theory and applications. Statistics in Medicine, 34(28), 3724–3749.

Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
